Attribute VB_Name = "mdTranslateAxes"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function TranslateAxes(xTranslation As Double, yTranslation As Double)

'Convenience Function to Translate the origin to a given point

'Get the ProDESKTOP Application object
GetApplicationObject

'Get the active Partdocument,Workplane
Dim Part As PartDocument
Set Part = app.GetActiveDoc
Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

'Create an origin vector
Dim vector1 As ZVector
Set vector1 = app.GetClass("Vector").CreateVector(xTranslation, yTranslation, 0)

'Get the transformation matrix for translating the origin
Dim transMatrix As zMatrix
      
Dim vector2 As ZVector
Dim vector3 As ZVector
Dim vector4 As ZVector

Set vector2 = wp.GetLocalOrigin()
Set vector3 = vector1.subtract(vector2)
   
Set transMatrix = app.GetClass("Matrix").CreateTranslationMatrix(vector3)
  
'Set the new origin
Set localorigin = wp.GetLocalOrigin
Set vector4 = transMatrix.MultiplyByVector(localorigin)
wp.SetLocalOrigin vector4
   
Dim dir1 As zDirection
Dim dir2 As zDirection
Dim dir3 As zDirection
Dim dir4 As zDirection
   
Set dir1 = wp.GetLocalX
Set dir2 = wp.GetLocalY
   
Set dir3 = transMatrix.MultiplyByDirection(dir1)
Set dir4 = transMatrix.MultiplyByDirection(dir2)
   
wp.SetLocalAxes dir3, dir4

End Function



